/* Copyright (C) 2025 Wildfire Games.
 * This file is part of 0 A.D.
 *
 * 0 A.D. is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * 0 A.D. is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with 0 A.D.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INCLUDED_ICMPFOGGING
#define INCLUDED_ICMPFOGGING

#include "simulation2/helpers/Player.h"
#include "simulation2/system/Component.h"
#include "simulation2/system/Interface.h"

#include <js/Value.h>

/**
 * Handles the fogging of out-of-sight enemy entities, by creating mirage
 * entities.
 * This allows hiding changes, especially destruction status or health.
 */
class ICmpFogging : public IComponent
{
public:
	virtual bool IsActivated() = 0;
	virtual bool WasSeen(player_id_t player) = 0;
	virtual bool IsMiraged(player_id_t player) = 0;
	virtual void ForceMiraging(player_id_t player) = 0;

	DECLARE_INTERFACE_TYPE(Fogging)
};

#endif // INCLUDED_ICMPFOGGING
