/* Copyright (C) 2025 Wildfire Games.
 * This file is part of 0 A.D.
 *
 * 0 A.D. is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * 0 A.D. is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with 0 A.D.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tools/atlas/AtlasUI/CustomControls/DraggableListCtrl/DraggableListCtrl.h"
#include "tools/atlas/AtlasUI/CustomControls/Windows/AtlasDialog.h"

class PropListEditorListCtrl;
class wxCommandEvent;
class wxWindow;

//////////////////////////////////////////////////////////////////////////

class PropListEditor : public AtlasDialog
{
public:
	PropListEditor(wxWindow* parent);
	static AtlasDialog* Create(wxWindow* parent) { return new PropListEditor(parent); }

protected:
	AtObj FreezeData();
	void ThawData(AtObj& in);

	AtObj ExportData();
	void ImportData(AtObj& in);

private:
	PropListEditorListCtrl* m_MainListBox;
};

//////////////////////////////////////////////////////////////////////////

class PropListEditorListCtrl : public DraggableListCtrl
{
	friend class PropListEditor;

public:
	PropListEditorListCtrl(wxWindow* parent);

	void OnUpdate(wxCommandEvent& event);

	void DoImport(AtObj& in);
	AtObj DoExport();
};
